/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.mixins;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFPlatform;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class CefWindowsShutdownMixin {
    @Inject(at={@At(value="TAIL")}, method={"close"})
    public void close(CallbackInfo ci) {
        if (MCEFPlatform.getPlatform().isWindows()) {
            String processName = "jcef_helper.exe";
            try {
                String line;
                ProcessBuilder processBuilder = new ProcessBuilder("tasklist");
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                boolean isRunning = false;
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(processName)) continue;
                    isRunning = true;
                    break;
                }
                reader.close();
                if (isRunning) {
                    MCEF.getLogger().warn("JCEF is still running, killing to avoid lingering processes.");
                    ProcessBuilder killProcess = new ProcessBuilder("taskkill", "/F", "/IM", processName);
                    killProcess.start();
                }
            }
            catch (Exception e) {
                MCEF.getLogger().error("Unable to check if JCEF is still running. There may be lingering processes.", (Throwable)e);
            }
        }
    }
}

